module.exports = (sequelize, DataTypes) => {
  const UserSuscription = sequelize.define(
    'UserSuscription',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      suscriptionTypeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'suscription_types',
          key: 'id',
        },
        field: 'suscription_types_id',
      },
      promotionalUsedCodesId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'promotional_used_codes',
          key: 'id',
        },
        field: 'promotional_used_codes_id',
      },
      transactionId: {
        allowNull: true,
        type: DataTypes.STRING(255),
        field: 'transaction_id',
      },
      transactionData: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'transaction_data',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
      resubscribedAt: {
        allowNull: true,
        type: DataTypes.DATE,
        field: 'resubscribed_at',
      },
      cancelledAt: {
        allowNull: true,
        type: DataTypes.DATE,
        field: 'cancelled_at',
      },
      lastNotificationReceived: {
        allowNull: true,
        type: DataTypes.STRING(50),
        field: 'last_notification_received',
      },
      purchaseToken: {
        allowNull: true,
        type: DataTypes.STRING(50),
        field: 'purchase_token',
      },
      originalTransactionIdentifierIOS: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'purchase_token',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_suscriptions',
    },
  );
  UserSuscription.associate = models => {
    UserSuscription.belongsTo(models.SuscriptionType, {
      foreignKey: 'suscriptionTypeId',
    });

    UserSuscription.belongsTo(models.PromotionalUsedCodes, {
      foreignKey: 'promotionalUsedCodesId',
    });

    UserSuscription.belongsTo(models.User, {
      foreignKey: 'userId',
    });

  };
  return UserSuscription;
};
