const moment = require('moment');
const db = require('../database/models');
const promotionalCode = require('../database/models/promotional-code');
const utils = require('../utils/utils');
const config = require('../config');

const {
  User,
  SuscriptionType,
  PromotionalUsedCodes,
  PromotionalCode,
  UserSuscription,
  Country
} = db;

exports.planCoachingMiddleware = async (req, res, next) => {
  try {
    const {
      _doc: { userId = null },
    } = req.user;

    const user = await User.findOne({
      attributes: ['id'],
      where: {
        id: userId,
      },
      include: [
        {
          model: UserSuscription,
          as: 'userSuscriptions',
          include: [
            {
              model: PromotionalUsedCodes,
              include: [
                { model: PromotionalCode },
              ]
            },
          ]
        },
      ],
    });
    if (user) {
      const {
        userSuscriptions = [],
      } = JSON.parse(JSON.stringify(user));
      const activeSuscriptionTypeIds = userSuscriptions.map(({ suscriptionTypeId }) => suscriptionTypeId);

      //console.log(`suscriptionTypeValidation middleware: userId: ${userId}, activeSuscriptionTypeIds: ${activeSuscriptionTypeIds} , valido hasta: ${promotionalCodes.length > 0 ? promotionalCodes[0].validFor : ""}`);
      let suscriptionType3 = userSuscriptions.filter(f => f.suscriptionTypeId === 3);
      suscriptionType3 = suscriptionType3.length > 0
        ? suscriptionType3[0]
        : {};

      const actUserSuscription = suscriptionType3;
      const { cancelledAt = null } = actUserSuscription;
      const promotionalCodes = (suscriptionType3.PromotionalUsedCode != null) ? (suscriptionType3.PromotionalUsedCode.PromotionalCode) : null;

      const currentDate = moment().utc();
      let dateOfExpiry = currentDate;
      if (config.get('env') == 'prod') {
        dateOfExpiry = cancelledAt ? moment(cancelledAt).utc().add(1, 'month') : currentDate;
      } else {
        dateOfExpiry = cancelledAt ? moment(cancelledAt).utc() : currentDate;
      }
      const isValid = currentDate < dateOfExpiry;

      let validPromotion = true;
      if (promotionalCodes != null) {
        validPromotion = (moment(promotionalCodes.validFor).utc() > currentDate)
      }

      const flag = !cancelledAt || isValid;

      if (activeSuscriptionTypeIds.includes(3) && flag && validPromotion) {
        return next();
      }

    }
    const name = 'USUARIO_NO_POSEE_PLAN_COACHING_ACTIVO';
    const extra = '';
    return utils.errorResponse(res, name, extra);
  } catch (e) {
    const name = 'USUARIO_NO_AUTORIZADO';
    const extra = '';
    return utils.errorResponse(res, name, extra);
  }

};
