const db = require('../database/models');
const utils = require('../utils/utils');
const serviceUtils = require('./utils.js');

const {
  Challenge, User, UserChallenge,
} = db;

exports.getChallenges = async userId => {
  try {
    const currentRoute = await serviceUtils.getCurrentUserRoute(userId);
    const { id: routeId = '' } = currentRoute;

    let challenges = await Challenge.findAll({
      attributes: ['id', 'name', 'icon', 'link'],
      where: { routeId },
      raw: true,
      include: [
        {
          model: User,
          as: 'userChallenges',
          attributes: [],
          through: {
            attributes: ['current'],
            where: { userId },
          },
        },
      ],
    });

    challenges = JSON.parse(JSON.stringify(challenges));

    challenges.map(c => {
      delete c['userChallenges.UserChallenge.id'];
      c.current = c['userChallenges.UserChallenge.current'] || 0;
      delete c['userChallenges.UserChallenge.current'];
      c.route = currentRoute;
      return c;
    });

    return { route: currentRoute, challenges };
  } catch (e) {
    throw e;
  }
};

exports.setCurrentChallenge = async (userId, challengeId) => {
  try {
    const routeChallenge = await Challenge.findOne({ where: { id: challengeId } });

    const { routeId = '' } = routeChallenge;

    let challengeIds = await Challenge.findAll({ where: { routeId } });

    challengeIds = challengeIds.map(c => c.id);

    await UserChallenge.update({ current: 0 }, { where: { challengeId: challengeIds, userId } });

    const result = await utils.updateOrCreate(
      UserChallenge,
      { challengeId, userId },
      {
        challengeId,
        userId,
        current: 1,
      },
    );

    const { created = '' } = result;
    if (created) {
      await serviceUtils.addToUserAspectReinventation(userId, challengeId, null);
    }

    return {};
  } catch (e) {
    throw e;
  }
};
