const db = require('../database/models');
const serviceUtils = require('./utils.js');

const {
  Gift, UserGift,
} = db;

exports.get = async ({
  userId, moment,
}) => {
  try {
    const { id: routeId = '' } = await serviceUtils.getCurrentUserRoute(userId);
    const { id: challengeId = '' } = routeId ? await serviceUtils.getCurrentUserChallenge(userId, routeId) || {} : {};

    let challengeIdCondition = {};

    if (moment === 'Finaliza configuracion de plan de accion' || moment === 'Finaliza configuracion del primer habito') {
      challengeIdCondition = {
        challengeId,
      };
    }

    const gifts = await Gift.findAll({
      attributes: ['id', 'type', 'challengeId', 'moment', 'title', 'text', 'link', 'width', 'height'],
      where: {
        routeId,
        moment,
        ...(challengeIdCondition),
      },
    });

    if (gifts.length > 0) {
      const giftPosition = serviceUtils.getRandomInt(gifts.length);
      const gift = gifts[giftPosition];

      await exports.viewedGift(userId, gift.id);
      return gift;
    }
    return {};
  } catch (e) {
    throw e;
  }
};

exports.viewedGift = async (userId, giftId) => {
  try {
    const existRecord = await UserGift.findOne({
      where: {
        userId,
        giftId,
      },
    });
    if (!existRecord) {
      await UserGift.create({
        userId,
        giftId,
      });
    }

    return {};
  } catch (e) {
    throw e;
  }
};
