const Aigle = require('aigle');
const moment = require('moment');
const db = require('../database/models');

const crypto = require('crypto');
const ECKey = require('ec-key');
const secp256k1 = require('secp256k1');
const { v4: uuidv4 } = require('uuid');
const { env } = require('process');

const {
  UserSuscription,
  Questionnarie,
  QuestionnarieBehavior,
  PromotionalCode,
  PromotionalType,
  PromotionalUsedCodes,
  User,
  Sequelize
} = db;

const { Op } = Sequelize;

/**
 * Create a user susbscription if doesn't exist
 */
exports.create = async ({ userId, suscriptionTypeId, promotionalCodeId, transactionData }) => {
  try {
    const {
      transactionId = null,
      purchaseToken = null,
      originalTransactionIdentifierIOS = null,
    } = transactionData;

    const deviceType = purchaseToken !== null ? 'Android' : 'Apple';
    console.group();
    console.log('transactionData', JSON.stringify(transactionData));
    console.log(`Tipo de dispositivo de la suscripcion: ${deviceType}`);
    console.log(`createSubscription userId: ${userId}, suscriptionTypeId: ${suscriptionTypeId}, transactionId: ${transactionId}`);

    const existUserSuscription = await UserSuscription.findOne({
      where: {
        userId,
        suscriptionTypeId,
      },
      paranoid: false,
    });
    var promotionalUsedCodesId = null;
    if (promotionalCodeId != null && promotionalCodeId != "" && promotionalCodeId != -1) {
      //Crear un registro de código promocional usado
      const promotionalUsedCode = await PromotionalUsedCodes.create({
        promCodeId: promotionalCodeId,
        userId,
        platform: deviceType === 'Android' ? 1 : 2
      });
      promotionalUsedCodesId = promotionalUsedCode.id;
    }



    if (!existUserSuscription) {
      console.log('SUSCRIPCION NO REGISTRADA');
      if (deviceType === 'Android') {
        console.log('SI deviceType === Android');
        const existAndroidSuscription = await UserSuscription.findOne({
          where: {
            purchaseToken,
            userId,
          },
          paranoid: false,
        });
        //Si obtenemos un código promotional de uso que se insertó bien, damos la opción de que el transaction id para cada plataforma sea vacío
        var updateValid = false;
        console.log("Token compra " + purchaseToken);
        updateValid = (purchaseToken != "" && purchaseToken != null && purchaseToken != undefined);
        if (existAndroidSuscription && updateValid) {
          console.log('SI existAndroidSuscription');
          await existAndroidSuscription.restore();
          await UserSuscription.update(
            {
              userId,
              promotionalUsedCodesId,
              transactionData: JSON.stringify(transactionData),
            },
            {
              where: {
                userId,
                purchaseToken,
              },
            },
          );
        } else {
          console.log('NO existAndroidSuscription');
          await UserSuscription.create({
            userId,
            suscriptionTypeId,
            promotionalUsedCodesId,
            transactionId,
            transactionData: JSON.stringify(transactionData),
            purchaseToken,
          });
        }
      } else {
        console.log('NO deviceType === Android');
        const existIosSuscription = await UserSuscription.findOne({
          where: {
            originalTransactionIdentifierIOS,
            userId,
          },
          paranoid: false,
        });
        var updateValid = false;
        console.log(originalTransactionIdentifierIOS);
        updateValid = ("Token compra " + originalTransactionIdentifierIOS != "" && purchaseToken != null && purchaseToken != undefined);
        if (existIosSuscription && updateValid) {
          console.log('SI existIosSuscription');
          await existIosSuscription.restore();
          await UserSuscription.update(
            {
              userId,
              transactionData: JSON.stringify(transactionData),
              promotionalUsedCodesId
            },
            {
              where: {
                originalTransactionIdentifierIOS,
                userId,
              },
            },
          );
        } else {
          console.log('NO existIosSuscription');
          await UserSuscription.create({
            userId,
            suscriptionTypeId,
            promotionalUsedCodesId,
            transactionId,
            transactionData: JSON.stringify(transactionData),
            originalTransactionIdentifierIOS: originalTransactionIdentifierIOS || transactionId,
          });
        }
      }
    } else {
      console.log('SUSCRIPCION REGISTRADA');

      await existUserSuscription.restore();
      if (deviceType === 'Android') {
        console.log('SI Android');
        await UserSuscription.update(
          {
            transactionId,
            transactionData: JSON.stringify(transactionData),
            purchaseToken,
            promotionalUsedCodesId,
            cancelledAt: null
          },
          {
            where: {
              userId,
              suscriptionTypeId,
            },
          },
        );
      } else {
        console.log('SI Apple');
        await UserSuscription.update(
          {
            transactionId,
            transactionData: JSON.stringify(transactionData),
            originalTransactionIdentifierIOS,
            promotionalUsedCodesId,
            cancelledAt: null
          },
          {
            where: {
              userId,
              suscriptionTypeId,
            },
          },
        );
      }
    }

    // Si suscriptionTypeId === 3 (plan coaching), revisamos si existe
    // un cuestionario relacionado a suscriptionTypeId === 2 (test de fortalezas / adn)
    // y creamos un cuestionario nuevo para el plan de coaching, copiando las respuestas del test de fortalezas.
    // Este comportamiento previene que usuario tenga que llenar de nuevo el cuestionario

    if (parseInt(suscriptionTypeId) === 3) {
      const adnQuestionnarie = await Questionnarie.findOne({
        where: {
          userId,
          suscriptionTypeId: 2,
        },
      });

      const coachingQuestionnarie = await Questionnarie.findOne({
        where: {
          userId,
          suscriptionTypeId: 3,
        },
      });

      if (adnQuestionnarie && !coachingQuestionnarie) {
        const newQuestionnarie = await Questionnarie.create({
          userId,
          suscriptionTypeId,
        });

        const adnAnswers = await QuestionnarieBehavior.findAll({
          where: {
            questionnarieId: adnQuestionnarie.id,
          },
        });

        await Aigle.mapSeries(adnAnswers, async a => {
          const { behaviorId = '', behaviorPointId = '' } = a;
          await QuestionnarieBehavior.create({
            questionnarieId: newQuestionnarie.id,
            behaviorId,
            behaviorPointId,
          });
        });
      }

    }

    console.groupEnd();

    return {};
  } catch (e) {
    throw e;
  }
};

exports.cancelOrResuscribedApple = async signedPayload => {
  try {

    // Se obtiene del payload la informacion de la notificacion
    /**
     * Documentacion de tipos de notificaciones:
     * https://developer.apple.com/documentation/appstoreservernotifications/app_store_server_notifications_v2
     *  */
    const bundleId = 'com.becrackapp';
    const splitInfoBase64 = signedPayload.split('.')[1];
    let notificationInfoJson = Buffer.from(splitInfoBase64, 'base64');
    notificationInfoJson = JSON.parse(notificationInfoJson.toString('ascii'));

    // Log
    console.log(notificationInfoJson);

    const { notificationType = '', data = '', subtype = '' } = notificationInfoJson;
    // Se verifica el bundleId
    if (data.bundleId !== bundleId) {
      console.log('Error: data.bundleId !== bundleId', data.bundleId);
      return {};
    }

    // Se verifica si es una notificacion de prueba
    if (notificationType === 'TEST') {
      return {};
    }

    // Se obtiene la informacion de la transaccion
    const {
      signedTransactionInfo: signedTransactionInfoBase64 = '',
      // signedRenewalInfo: signedRenewalInfoBase64 = '',
    } = data;


    /**
     * Documentacion de JWSTransactionDecodedPayload
     * https://developer.apple.com/documentation/appstoreservernotifications/jwstransactiondecodedpayload
     *  */
    const splitSignedTransactionInfoBase64 = signedTransactionInfoBase64.split('.')[1];
    let signedTransactionInfoJson = Buffer.from(splitSignedTransactionInfoBase64, 'base64');
    signedTransactionInfoJson = JSON.parse(signedTransactionInfoJson.toString('ascii'));

    /**
     * Documentacion de JWSRenewalInfoDecodedPayload
     * https://developer.apple.com/documentation/appstoreservernotifications/jwsrenewalinfodecodedpayload
     *
     * Este  objeto tambien se puede emplear para obtener el originalTransactionId. Se deja comentado por si es de utilidad a futuro.
     *  */
    /* const splitSignedRenewalInfo = signedRenewalInfoBase64.split('.')[1];
    let signedRenewalInfoJson = Buffer.from(splitSignedRenewalInfo, 'base64');
    signedRenewalInfoJson = JSON.parse(signedRenewalInfoJson.toString('ascii')); */

    const { originalTransactionId = null } = signedTransactionInfoJson;

    if (originalTransactionId) {
      const subscription = await UserSuscription.findOne({
        where: {
          originalTransactionIdentifierIOS: originalTransactionId,
        },
        paranoid: false,
      });

      if (subscription) {

        // Se recupera el registro, para el caso en el que haya sido eliminado previamente
        subscription.restore();

        // Si la suscripcion fue cancelada
        /**
         * Documentacion de tipos de notificaciones:
         * https://developer.apple.com/documentation/appstoreservernotifications/notificationtype
         * https://developer.apple.com/documentation/appstoreservernotifications/subtype
         *  */
        if (['DID_FAIL_TO_RENEW', 'EXPIRED', 'REVOKE'].includes(notificationType)) {

          console.log(`POSIBLE CANCELACION. SUSCRIPTION_ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}.${subtype}`);

          if (subtype === '' || ['VOLUNTARY', 'BILLING_RETRY', 'PRICE_INCREASE', 'PRODUCT_NOT_FOR_SALE', 'GRACE_PERIOD'].includes(subtype)) {
            await subscription.update(
              {
                cancelledAt: moment().utc(),
                lastNotificationReceived: `${notificationType}.${subtype}`,
              },
            );

            console.log(`SUSCRIPCION CANCELADA - ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}.${subtype}`);
          }

        }

        // Si la suscripcion fue activada o renovada
        if (['DID_RENEW', 'SUBSCRIBED'].includes(notificationType)) {

          // Si la suscripcion esta activa
          if (subtype === '' || ['INITIAL_BUY', 'RESUBSCRIBE', 'BILLING_RECOVERY'].includes(subtype)) {

            await subscription.update(
              {
                cancelledAt: null,
                resubscribedAt: moment().utc(),
                lastNotificationReceived: `${notificationType}.${subtype}`,
              },
            );
            console.log(`SUSCRIPCION ACTIVA ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}.${subtype}`);

          } else { // Si es cualquier otro subtype relacionado con una suscripcion activa

            await subscription.update(
              {
                cancelledAt: null,
                lastNotificationReceived: `${notificationType}.${subtype}`,
              },
            );
            console.log(`SUSCRIPCION ACTIVA OTROS - ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}.${subtype}}`);
          }

        }

        // Otros eventos
        if (['CONSUMPTION_REQUEST', 'DID_CHANGE_RENEWAL_STATUS', 'DID_CHANGE_RENEWAL_PREF', 'PRICE_INCREASE'].includes(notificationType)) {
          await subscription.update(
            {
              lastNotificationReceived: `${notificationType}.${subtype}`,
            },
          );
          console.log(`OTRO - ID:${subscription.id} - NOTIFICATION TYPE: ${notificationType}.${subtype}}`);
        }

      } else {
        console.log('NO SE ENCONTRO LA SUSCRIPCION');
      }
    }

    return {};

  } catch (e) {
    throw e;
  }
};

exports.cancelOrResuscribedAndroid = async data => {
  try {

    /**
     * Documentacion de notificaciones
     * https://developer.android.com/google/play/billing/rtdn-reference
     *
     * Tipos de notificaciones
     * https://developer.android.com/google/play/billing/rtdn-reference#sub
     */

    // Se verifica la suscripcion
    const messageSubscription = 'projects/becrackapp/subscriptions/userSuscriptionUpdates-devsub';
    if (data.subscription !== messageSubscription) {
      console.log('Error: data.subscription !== messageSubscription', data.subscription);
      return {};
    }

    // Se decodifica el mensaje de la notificacion
    const messageData = data.message.data;
    let decodedMessageData = Buffer.from(messageData, 'base64');
    decodedMessageData = JSON.parse(decodedMessageData.toString('ascii'));

    // Se  verifica el paquete
    const packageName = 'com.becrackapp';
    if (decodedMessageData.packageName !== packageName) {
      console.log('Error: decodedMessageData.packageName !== packageName', decodedMessageData.packageName);
      return {};
    }

    // Se verifica si la notificacion es de prueba
    if (decodedMessageData.testNotification) {
      console.log('Test notification');
      return {};
    }

    if (decodedMessageData.subscriptionNotification && decodedMessageData.subscriptionNotification.purchaseToken) {
      const { notificationType, purchaseToken } = decodedMessageData.subscriptionNotification;
      console.log('DATA DE LA SUSCRIPCION', decodedMessageData.subscriptionNotification);
      const subscription = await UserSuscription.findOne({
        where: {
          purchaseToken,
        },
        paranoid: false,
      });

      if (subscription) {

        subscription.restore();

        if ([3, 5, 10, 12, 13].includes(notificationType)) {
          await subscription.update(
            {
              cancelledAt: moment().utc(),
              lastNotificationReceived: notificationType,
            },
          );
          console.log(`SUSCRIPCION CANCELADA ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}`);
        }

        if ([1, 2, 4, 7].includes(notificationType)) {
          await subscription.update(
            {
              cancelledAt: null,
              resubscribedAt: moment().utc(),
              lastNotificationReceived: notificationType,
            },
          );
          console.log(`SUSCRIPCION ACTIVA ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}`);
        }

        if ([8, 9, 11].includes(notificationType)) {
          await subscription.update(
            {
              lastNotificationReceived: notificationType,
            },
          );
          console.log(`OTRO EVENTO ID:${subscription.id}. NOTIFICATION TYPE: ${notificationType}`);
        }
      } else {
        console.log('NO SE ENCONTRO LA SUSCRIPCION');
      }
    }

    return {};

  } catch (e) {
    throw e;
  }
};

/*NEW Recibe un código de promoción e identifica si existe algún producto disponible*/
exports.validPromotion = async ({ userId, code }) => {

  try {
    //Buscamos el correo del usuario acá también se valida que exista
    const findUserEmail = await User.findOne({
      where: { id: userId },
    });
    if (!findUserEmail) {
      const error = {
        name: 'USUARIO_NO_EXISTE',
      };
      throw error;
    }
    // Si se Recibe un código validamos que sea valido
    if (code) {
      const codeInfo = await PromotionalCode.findAll({
        attributes: [
          ['id', 'id'],
          ['promotionalcode', 'promotionalcode'],
          ['validthru', 'validthru'],
          ['validfrom', 'validfrom'],
          ['maxusetimes', 'maxusetimes'],
          ['scope', 'scope'],
          [db.sequelize.fn('COUNT', db.sequelize.col('PromotionalUsedCodes.promotional_code_id')), 'usedTimes'],
        ],
        include: [
          {
            model: PromotionalType, required: true,
            attributes: [
              [db.sequelize.col('type'), 'productType'],
              [db.sequelize.col('suscription_type_id'), 'typeId'],
              [db.sequelize.col('google_id_product'), 'google_id_product'],
              [db.sequelize.col('apple_id_product'), 'apple_id_product'],
              [db.sequelize.col('promotionid'), 'promotionid']
            ]
          },
          { model: PromotionalUsedCodes, required: false, attributes: [] }
        ],
        where: {
          promotionalCode: code,
          validFrom: { [Op.lte]: new Date() },
          validThru: { [Op.gte]: new Date() },
        },
        group: ['id']
      });

      // Si obtenemos una respuesta válida continuamos
      if (!codeInfo) {
        const error = {
          name: 'PROMOTIONAL_CODE_INVALIDO',
        };
        throw error;
      }

      if (codeInfo.length <= 0) {
        const error = {
          name: 'PROMOTIONAL_CODE_INVALIDO',
        };
        throw error;
      }

      const data = (codeInfo[0]['dataValues']);
      //Se valida que todavía no exceda el número de veces que se puede usar
      if (data['usedTimes'] >= data['maxusetimes']) {
        const error = {
          name: 'PROMOTIONAL_CODE_INVALIDO',
        };
        throw error;
      }

      //Se validan los scrope
      let email = findUserEmail.email;
      if (data['scope'] != "") {
        let scopesarr = data['scope'].split(",");
        var anymatch = false;
        for (var i = 0; i < scopesarr.length; i++) {
          var scope = (scopesarr[i].trim());
          if (scope !== "") {
            if (scope.charAt(0) == '*') {
              var tovalid = scope.substring(1, (scope.length - 1));
              if (email.includes(tovalid)) {
                anymatch = true;
                i = (scopesarr.length + 1);
              }
            } else if (scope.charAt((scope.length - 1)) == '*') {
              var tovalid = scope.substring(0, (scope.length - 2));
              if (email.includes(tovalid)) {
                anymatch = true;
                i = (scopesarr.length + 1);
              }
            } else {
              if (email == scope) {
                anymatch = true;
                i = (scopesarr.length + 1);
              }
            }
          }
        }
        if (!anymatch) {
          const error = {
            name: 'PROMOTIONAL_CODE_INVALIDO',
          };
          throw error;
        }
      }

      const user = await User.findOne({
        attributes: ['id'],
        where: {
          id: userId,
        },
        include: [
          {
            model: PromotionalUsedCodes,
            as: 'promotionalUsedCodes',
            include: [
              {
                model: PromotionalCode,
                include: [
                  {
                    model: PromotionalType,
                    where: {
                      iosProductId: data['PromotionalType']['dataValues']['apple_id_product'],
                      promotionType: {
                        [Op.ne]: 'free'
                      },
                      suscriptionTypeId: 3
                    }
                  }
                ],
                where: {
                  id: { [Op.ne]: null }
                }
              },
            ],
          },
        ],
      });
      const {
        promotionalUsedCodes = [],
      } = JSON.parse(JSON.stringify(user));
      console.log(promotionalUsedCodes);
      //OBJETO DE RESPUESTA
      let iosoffer = setIosOffer(data['PromotionalType']['dataValues']);

      let newdata = {};
      newdata = data['PromotionalType'];
      newdata.id = data['id'];
      newdata.dataValues.iosoffer = iosoffer;
      if (promotionalUsedCodes.length > 0) { //Significa que el usuario adquierió este producto al menos una vez por la tienda osea ignora el intro y debe ser prom
        newdata.dataValues.apple_id_product = newdata.dataValues.apple_id_product + "_prom";
      } else {
        const userSus = await User.findOne({
          attributes: ['id'],
          where: {
            id: userId,
          },
          include: [
            {
              model: UserSuscription,
              as: 'userSuscriptions',
              include: [
                {
                  model: PromotionalUsedCodes,
                  include: [
                    { model: PromotionalCode },
                  ]
                },
              ]
            },
          ],
        });
        if (userSus) {
          const {
            userSuscriptions = [],
          } = JSON.parse(JSON.stringify(userSus));
          let suscriptionType3 = userSuscriptions.filter(f => f.suscriptionTypeId === 3);
          if (suscriptionType3.length > 0) {
            suscriptionType3 = suscriptionType3.length > 0 ? suscriptionType3[0] : {};
            const actUserSuscription = suscriptionType3;
            const { cancelledAt = null } = actUserSuscription;
            if (cancelledAt != null) {
              newdata.dataValues.apple_id_product = newdata.dataValues.apple_id_product + "_intro";
            } else {
              newdata.dataValues.apple_id_product = newdata.dataValues.apple_id_product + "_prom";
            }
          } else {
            newdata.dataValues.apple_id_product = newdata.dataValues.apple_id_product + "_intro";
          }
        }

      }
      return newdata; //Devolvemos el objeto código promocional encontrado
    }

    return {};
  } catch (e) {
    console.log("no se recibió")
    throw e;
  }
};

function setIosOffer(values) {
  let env = "prod";
  let appBundleID = 'com.becrackapp';
  let productIdentifier = values['apple_id_product'];
  let subscriptionOfferID = values['promotionid'];
  let keyID = getKeyID(env);
  let nonce = uuidv4();
  let timestamp = Math.floor(new Date());
  let applicationUsername = "";
  let payload = appBundleID + '\u2063' + keyID + '\u2063' + productIdentifier + '\u2063' + subscriptionOfferID + '\u2063' + applicationUsername + '\u2063' + nonce + '\u2063' + timestamp;
  let privKey = getPrivKey(env);

  // Create an Elliptic Curve Digital Signature Algorithm (ECDSA) object using the private key.
  const key = new ECKey(privKey, 'pem');
  // Set up the cryptographic format used to sign the key with the SHA-256 hashing algorithm.
  const cryptoSign = key.createSign('SHA256');
  // Add the payload string to sign.
  cryptoSign.update(payload);
  const signature = cryptoSign.sign('base64');
  //Validation
  const verificationResult = key.createVerify('SHA256').update(payload).verify(signature, 'base64');
  console.log("Verification result: " + verificationResult)

  return { 'keyID': keyID, 'nonce': nonce, 'timestamp': timestamp, 'signature': signature, 'promotionid': subscriptionOfferID };
}
function getKeyID(env = 'dev') {
  return (env == 'dev') ? 'C6C23E12' : 'P5HB2CMT35';
}
function getPrivKey(env = 'dev') {
  let privKey = `-----BEGIN PRIVATE KEY-----
MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgW+cq8a5koXQlJpqG
FqYqVLOaAlqP7SZ80Zb2m2PFK+ShRANCAARFJQ19hfT77QMwlAyZqJlcIYLNGRod
KZ3jcdawMUoq9qh5HrCe0rz6niB0wodkmozI7vDlZr5mJMPhEhaWDPn8
-----END PRIVATE KEY-----`;

  let privKeyDev = `-----BEGIN PRIVATE KEY-----
MIGTAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBHkwdwIBAQQgY0oyD2JYBZzSDvDP
AxSH+4iwemrtKZeNgp5+NO7eQUegCgYIKoZIzj0DAQehRANCAAS8AUJqJmgAPrRf
SGdKAqX7qdQx0LMCkwPf90e3oxLixhfAyTCYLo0W9OHWvrpn1itukdb3y5R8HUaq
+/Nf1YXR
-----END PRIVATE KEY-----`;

  return (env == 'dev') ? privKeyDev : privKey;
}